(*********************************************************************************
* Copyright: Bernecker+Rainer
* Author:    Mikael Regard
* Created:   May 13, 2019/8:21 AM 
* Updated:   Aug 19, 2019/09:00 AM
 *********************************************************************************
 * Description:
 * FuB to Get PMC Status.
 * Power consumption, and maximum temperatures for a flyway are returned.
 * 
 *Input:
 * MsgFrame  (Profinet output frame)
 * ReadFrame (Profinet reply frame)
 * Execute   (Edgepos, Execute = TRUE will run the FuB once)
 * Cmd Label (Optional 2 byte Command label. Used to identify specfic commands. 
 *
 * Output:
 * Error (Indicates if there is an error)
 * Busy  (FuB will be Busy until reply)
 * Done  (When Accepted command is received, Done = TRUE)
 * NumOfXbot (Number of Xbot in system)
 * PMCState (0 = Booting, 1 = Inactive, 2 = Activating, 3,4 and 6 = Reserved, 5 = Operation, 7 = Deactivating, 8 = Error handling, 9 = Error)
 * Power    (Power Consumption all Flyways)
 * PaTemp   (Maximum amplifier temperature of all flyways)
 * CpuTemp  (Maximum CPU Temp of all flyways)
 * MotorTemp (Maximum motor temp of all Flyways)
 * ErrorID (0x0001 = System Error, 0x2000 = Wrong PMC State, 0x2001 = No Mastership, 0x2002 = Mastership timeout,
 *		    0x2003 = Wrong group state, 0x2004 = Wrong Macro state, 0x2005 = Wrong Digital IO state,
 *          0x2006 = Wrong flyways state, 0x3000 = Wrong Xbot state, 0x4000 = Paramter Error: Invalid Parameters.
 *********************************************************************************)






FUNCTION_BLOCK PM_GetPMCStatus
	
	// Check Reply
	IF(Busy)THEN
		brsmemcpy(ADR(CmdLbl),ADR(ReadFrame[3]),2);
		IF(ReadFrame[0] = CmdCount AND
			ReadFrame[1] 	= 5  AND
			ReadFrame[2]	= 10 AND
			CmdLbl = CmdLabel)THEN
			Done 	:= TRUE;
			Busy 	:= FALSE;
			brsmemcpy(ADR(ErrorID),ADR(ReadFrame[5]),2);
			Error 	:= UINT_TO_BOOL(ErrorID);
			Done 	:= NOT(UINT_TO_BOOL(ErrorID));
			
			PMCState	:= ReadFrame[8];
			brsmemcpy(ADR(NumOfXbot),ADR(ReadFrame[9]),2);
			brsmemcpy(ADR(Power),ADR(ReadFrame[15]),4);
			brsmemcpy(ADR(CpuTemp),ADR(ReadFrame[19]),1);
			brsmemcpy(ADR(PaTemp),ADR(ReadFrame[20]),1);
			brsmemcpy(ADR(MotorTemp),ADR(ReadFrame[21]),1);	
		ELSE
			Busy := FALSE;
		END_IF;
	END_IF;
	//Send Command		
	IF(Execute AND NOT(Done) AND NOT(Error))THEN
		IF(NOT(Busy))THEN
			brsmemset(ADR(MsgFrame[1]),FALSE,98);
			CmdCount 		:= ReadFrame[0] +1;
			MsgFrame[0] 	:= CmdCount; 
			MsgFrame[1] 	:= 5;
			MsgFrame[2] 	:= 10;
			brsmemcpy(ADR(MsgFrame[3]), ADR(CmdLabel), 2);
			Busy := TRUE;	
		END_IF;
	//Reset output status	
	ELSIF(NOT(Execute))THEN
		Busy := FALSE;
		Done := FALSE;
		Error := FALSE;
		ErrorID := 0;
	END_IF
	
	
	
END_FUNCTION_BLOCK
